"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomDriver = void 0;
const user_event_1 = __importDefault(require("@testing-library/user-event"));
/**
 * A DOM-based TestDriver. This works in environments where the DOM is directly
 * available, such as Jest or Karma.
 */
exports.DomDriver = {
    executeScript(script, ...args) {
        const ret = new Function(`
      function execute() {
        ${script}
      }
      return execute.call(undefined, ${args.map(JSON.stringify).join(', ')});
    `)();
        return Promise.resolve(ret);
    },
    findElement(query) {
        const el = document.querySelector(query);
        if (el) {
            return Promise.resolve(wrapElement(el));
        }
        throw Error(`No element matching query "${query}"`);
    },
    findElements(query) {
        return Promise.resolve(Array.from(document.querySelectorAll(query)).map(wrapElement));
    },
    click(element) {
        return user_event_1.default.click(element.el);
    },
    sendKeys(element, text) {
        return user_event_1.default.type(element.el, text);
    }
};
function wrapElement(element) {
    return new ElementWrapper(element);
}
class ElementWrapper {
    constructor(element) {
        this.el = element;
    }
    findElement(query) {
        const el = this.el.querySelector(query);
        if (el) {
            return Promise.resolve(wrapElement(el));
        }
        throw Error(`No element matching query "${query}"`);
    }
    findElements(query) {
        return Promise.resolve(Array.from(this.el.querySelectorAll(query)).map(wrapElement));
    }
}
