"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDriver = exports.setDriver = void 0;
let _driver;
/**
 * Set the TestDriver instance to be used for testing. This method should be called by
 * tests during setup, before calling any test adapter methods.
 *
 * @param driver The TestDriver instance
 */
function setDriver(driver) {
    _driver = driver;
}
exports.setDriver = setDriver;
/**
 * Get the configured TestDriver instance to be used for testing. This method should
 * only be called by test adapters to interact with the browser environment.
 *
 * @returns {TestDriver} The TestDriver instance
 */
function getDriver() {
    if (!_driver) {
        throw Error('Driver has not been set. Call setDriver()');
    }
    return _driver;
}
exports.getDriver = getDriver;
