"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElement = exports.getByTestId = void 0;
const UNSAFE_driver_1 = require("../UNSAFE_driver");
/**
 * Create a locator that targets an element by its testId
 * @param testId
 * @returns The ElementLocator for the given testId
 */
function getByTestId(testId) {
    return {
        css: getTestIdQuery(testId)
    };
}
exports.getByTestId = getByTestId;
function getTestIdQuery(testId) {
    return `[data-testid=${testId}]`;
}
/**
 * Perform an element search on the driver using the given ElementLocator
 * @param locator
 * @returns
 */
async function getElement(locator) {
    const matches = await (0, UNSAFE_driver_1.getDriver)().findElements(locator.css);
    if (!matches.length) {
        throw Error(`No matches found for "${locator.css}"`);
    }
    return matches[0];
}
exports.getElement = getElement;
